<?php
/**
 * Smart CSV Lists Front Office Feature
 *
 * NOTICE OF LICENSE
 *
 * @category marketing
 * @author    Pol Rué
 * @copyright Smart Modules 2014
 * @version 1.5.3
 * @license   GNU Public License 2.0 (read license.txt for more details)
 * Registered Trademark & Property of Smart-Modules.pro
 *
 * *************************************
 * * Facebook Conversion Tracking Pixel *
 * *   http://www.smart-modules.pro       *
 * *               V 1.5.3                 *
 * *************************************
 *
 *
 *
 * Versions:
 * 1.0 First stable release: After using this module with our websites we decided to contribute with Prestashop Addons
 * 1.1 Update the code to fit new Facebook Tracking Pixel Code. Added Spanish and Catalan Translations.
 * 1.2 Fixed some bugs, better compatibility with 1.5.x
 * 1.3 Now compatible with Presta 1.4
 * 1.3.1 Now compatible with Presta 1.6.14
 * 1.3.2 Small bug Fixed
 * 1.3.3 Small bug Fixed in Presta 1.4
 * 1.3.4 Small bugs Fixed
 * 1.5.0 Uses New Facebook Pixel
 * 1.5.1 Better documentation 
 * 1.5.2 Made compatible with 1.4.X versions again
 * 1.5.3 Added French translations
*/

if (!defined('_PS_VERSION_')) {
    exit;
}
class FacebookConversionPixel extends Module
{
    private $_html = '';
    public function __construct()
    {
        $this->name = 'facebookconversionpixel';
        $this->tab = 'advertising_marketing';
        $this->version = '1.5.3';
        $this->author = 'Smart Modules';
        $this->need_instance = 0;
        $this->module_key = '3f7248bdf6ad77285b0f6aabca543c58';
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Facebook Conversion Tracking Pixel');
        $this->description = $this->l('Allows Facebook to track conversions of the store');
        /* Backward compatibility */
        if (_PS_VERSION_ < '1.5') {
               require(_PS_MODULE_DIR_.$this->name.'/backward_compatibility/backward.php');
        }
    }
    public function install()
    {
        if (_PS_VERSION_ < '1.5') {
            if (!parent::install()
                || !$this->registerHook('orderConfirmation')
                || !$this->registerHook('header')
                || !$this->registerHook('paymentReturn')
                || !$this->registerHook('newOrder')
                ) {
                    return false;
            }
        } else {
            if (!parent::install()
                || !$this->registerHook('orderConfirmation')
                || !$this->registerHook('displayHeader')
                || !$this->registerHook('header')
                || !$this->registerHook('actionValidateOrder')
                || !$this->registerHook('displayOrderConfirmation')
                || !$this->registerHook('paymentReturn')) {
                    return false;
            }
        }
        Configuration::updateValue('FCP_VALUE', "");
        Configuration::updateValue('FCP_ORDER_CONVERSION', "");
        return true;
    }
    public function uninstall()
    {
        Configuration::deleteByName('FCP_VALUE');
        Configuration::deleteByName('FCP_ORDER_CONVERSION');
        return parent::uninstall();
    }
    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submit'.$this->name)) {
            if (Tools::getValue('FCP_VALUE') != '') {
                 $my_module_name = Tools::getValue('FCP_VALUE');
                 Configuration::updateValue('FCP_VALUE', $my_module_name);
                 $output .= $this->displayConfirmation($this->l('Settings updated'));
            }
        }
        if (_PS_VERSION_ < '1.5') {
            $output .= '<fieldset><legend>'.$this->l('How to set up conversions tracking').'</legend>'.$this->display(__FILE__, 'views/templates/admin/configuration.tpl').'</fieldset><br style="height:60px; clear:both">';
        } else {
            $output .= $this->context->smarty->fetch($this->local_path.'views/templates/admin/configuration.tpl');
        }
        
        $js = '
        <script type="text/javascript">
        $(document).ready(function() {
            if ($("#FCP_VALUE").val() != "") {
                var pixelid = $("#FCP_VALUE").val();
                $("#FCP_VALUE_TMP").parent().hide();
                $("#fieldset_0 label:first").hide();
                $("#FCP_VALUE_TMP").closest("p").hide();
                $("input#FCP_VALUE").after("<br/><a id=\"newcode\" href=\"#\" title=\"'.$this->l("Click to enter a new code").'\">'.$this->l("Click to enter a new code").'</a>");
                $("#newcode").after("<h3 ';
                // Adapt to 1.6 BO Syles
        if (strpos(_PS_VERSION_, '1.6') === false) {
            $js .= 'style=\"position:absolute; margin-top:-35px; margin-left: 160px;\"';
        }
          $js .= '><!--<a id=\"validatepixel\" href=\"#\" title=\"'.$this->l("Click to validate pixel now").'\">'.$this->l("Validate Pixel now").'</a>--></h3>");
            }
            $("#FCP_VALUE_TMP").bind("input propertychange", function() {
                var text = $(this).val();
                var p= text.indexOf("?ev=")+4;
                var q= text.indexOf("&amp;");
                text = text.substr(text.indexOf("?ev=")+4,text.indexOf("&amp;")-(text.indexOf("?ev=")+4))
                if (text != "" && !isNaN(text)) {
                    $("#FCP_VALUE").val(text);
                }
                else {
                    text=get_pixel_id(text);
                }
            });
            var Timer;
            var TotalSeconds;
            function UpdateTimer() {
                Timer.innerHTML = TotalSeconds;
            }
            function Tick() {
                TotalSeconds -= 1;
                UpdateTimer();
                window.setTimeout(function(){Tick()}, 1000);
            }
            function CreateTimer(TimerID, Time) {
                Timer = document.getElementById(TimerID);
                TotalSeconds = Time;
                UpdateTimer();
                window.setTimeout(function(){Tick()}, 1000);
            }
            $("#validatepixel").bind(\'click\',function(e) {
                $("body").append(\'<div id="pixelvalidationholder" style="width:100%; height:100%; z-index:1000; left:0; top:0; position:fixed; background: rgba(0,0,0,0.6)"><div id="pixelvalidation" style="width:50%; margin:15% 25% 0; background:#fff; border-radius:20px; padding:25px;"><h1>'.$this->l('Pixel Validated').'</h1><h3>'.$this->l('Now just go to Facebook and click refresh').'</h2><p>This dialog will close in <span id="TimerID">5</span> seconds<p><img style="content:\"f\"" height="10" width="10" alt="" style="display:none" src="https://www.facebook.com/tr?ev=\'+pixelid+\'&amp;cd[value]=0&amp;cd[currency]=EUR&amp;noscript=1" /><div></div>\');
                CreateTimer("TimerID",5);
                setTimeout(function() {$("#pixelvalidation").fadeOut(2000)},4500);
                setTimeout(function() {$("#pixelvalidationholder").fadeOut(1500)},5000);
                setTimeout(function() {$("#validatepixel").parent().hide()},2500);
            });
            $("#newcode").click(function() {
                $(this).hide();
                $("#FCP_VALUE_TMP").parent().show();
                $("#fieldset_0 label:first").show();
                $("#FCP_VALUE_TMP").closest("p").show();
                $("#validatepixel").parent().hide()
            });
            function get_pixel_id(text) {
                var tmp=0;
                for (var i=0; i<text.length; i++) {
                    if (!isNaN(text[i]) && text[i] != "" && text[i] != " ") {
                        tmp = text[i];
                        for (var j=i; j<text.length; j++) {
                            if (!isNaN(text[j]) && text[j] != "" && text[j] != " ") {
                                tmp += text[j];
                            }
                            else break;
                        }
                        if (tmp > 100000)
                            return tmp;
                    }
                }
                return false;
            }
        });
        </script>';
        return $output.$this->displayForm().$js;
    }
    public function displayForm()
    {
    /* Backward compatibility */
        if (_PS_VERSION_ < '1.5') {
            return $this->displayOldForm();
        } else {
             // Get default Language
             $default_lang = (int)Configuration::get('PS_LANG_DEFAULT');
             $fields_form = array();
             // Init Fields form array
             $fields_form[0]['form'] = array(
                 'legend' => array(
                     'title' => $this->l('Facebook Conversion Tracking Pixel Settings'),
                 ),
                 'input' => array(
                     array(
                         'type' => 'text',
                         'label' => $this->l('Pixel ID:'),
                         'name' => 'FCP_VALUE',
                         'size' => 20,
                         'placeholder' => $this->l('Facebook\'s Pixel ID'),
                         'required' => true,
                         'desc' => $this->l('Enter here the Facebook\'s Pixel\'s ID obatained by following the instructions above.')
                     )
                 ),
                 'submit' => array(
                     'title' => $this->l('Save'),
                     'name' => 'submitfacebookconversionpixel',
                     'id' => 'submitfacebookconversionpixel',
                     'class' => 'button'
                 )
             );
             $helper = new HelperForm();
             // Module, token and currentIndex
             $helper->module = $this;
             $helper->name_controller = $this->name;
             $helper->token = Tools::getAdminTokenLite('AdminModules');
             $helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name.'&module_name='.$this->name.'&tab_module='.$this->tab;
             // Language
             $helper->default_form_language = $default_lang;
             $helper->allow_employee_form_lang = $default_lang;
             // Title and toolbar
             $helper->title = $this->displayName;
             $helper->show_toolbar = true;        // false -> remove toolbar
             $helper->toolbar_scroll = true;      // yes - > Toolbar is always visible on the top of the screen.
             $helper->submit_action = 'submit'.$this->name;
             $helper->toolbar_btn = array(
                 'back' => array(
                     'href' => AdminController::$currentIndex.'&token='.Tools::getAdminTokenLite('AdminModules'),
                     'desc' => $this->l('Back to list')
                 )
             );
             // Load current value
             $helper->fields_value['FCP_VALUE'] = Configuration::get('FCP_VALUE');
             $helper->fields_value['FCP_VALUE_TMP'] = "";
             return $helper->generateForm($fields_form);
        }
    }
    public function displayOldForm()
    {
        $output = '<form class="form" action="'.Tools::htmlentitiesUTF8($_SERVER['REQUEST_URI']).'&submitfacebookconversionpixel" method="post">
        <fieldset style="float:left;width:600px;"><legend>'.$this->l('Facebook Conversion Tracking Pixel Settings').'</legend>
            <div style="float:left; width:20%;">
                <label for="FCP_VALUE_TMP">'.$this->l('Enter here the Facebook\'s Pixel\'s ID obatained by following the instructions above.').'</label>
            </div>
            <div style="clear:both"></div>
            <div class="" style="float:left; width:20%;">
                <label for="FCP_VALUE">'.$this->l('Pixel ID:').'</label>
            </div>
            <div class="" style="float:right; width:60%;">
                <input name="FCP_VALUE" id="FCP_VALUE" size=20 style="width:100%;" value="'.Configuration::get('FCP_VALUE').'" />
            <div style="clear:both"></div>
            </div>
            <div class="margin-form" style="padding-left:40%;">
                <div style="clear:both"></div>
                <input style="margin-top:15px;" value="'.$this->l('Save').'" name="submitfacebookconversionpixel" id="submitfacebookconversionpixel" class="button" type="submit">
            </div>
        </fieldset>
        </form>';
        return $output;
    }
    public function hookDisplayOrderConfirmation($params)
    {
        $ovalue = '';
        $ocurrency = '';
        $validation = Configuration::get('FCP_ORDER_CONVERSION');
        if ($validation != '' && !empty($validation)):
            $validation = explode(":", $validation);
            if((int)$params['objOrder']->id_customer == (int)$validation[0] || (int)$this->context->cookie->id_customer == (int)$validation[0]):
                $ovalue = $validation[1];
                $ocurrency = $validation[2];
                Configuration::deleteByName('FCP_ORDER_CONVERSION', '');
            endif;
        endif;
        if ($ovalue == '' || $ocurrency == ''):
            $ovalue = (float)$params['objOrder']->total_paid;
            $ocurrency = $this->context->currency->iso_code;
        endif;
        if ($ovalue != '') {
            // Order Successfull
            $ordervars = array(
            'ordervalue' => $ovalue,
            'currency' => $ocurrency);
            $this->smarty->assign('ordervars', $ordervars);
            $this->smarty->assign(array(
                    'total_to_pay' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false),
                    'status' => 'ok',
                    'id_order' => $params['objOrder']->id
                ));
            return $this->display(__FILE__, '/views/templates/hook/facebookconversionpixel.tpl');
        }
    }
    public function hookPaymentReturn($params)
    {
        return $this->hookDisplayOrderConfirmation($params);
    }
    public function hookOrderConfirmation($params)
    {
        return $this->hookDisplayOrderConfirmation($params);
    }
    public function hookActionValidateOrder($params)
    {
        $order = $params['objOrder'];
        $id = $order->id;

        // Compatibility check
        if ($id == '') {
            $id = $order->id_order;
        }

        $currency = new Currency((int)$order->id_currency);
        $total_paid = Tools::ps_round((float)$order->total_paid);
        $orderstring = $order->id_customer.":".$total_paid.":".$currency->iso_code;
        Configuration::updateValue('FCP_ORDER_CONVERSION', $orderstring);
    }
    public function paymentConfirm($params)
    {
        // 1.4 Versions
        return $this->hookActionValidateOrder($params);
    }
    public function hookDisplayHeader()
    {
        $fbctp = Configuration::get('FCP_VALUE');
        $this->context->smarty->assign(array('pixel_id' => $fbctp));
        return $this->display(__FILE__, '/views/templates/hook/facebookpixelheader.tpl');
    }
    public function hookHeader()
    {
        return $this->hookDisplayHeader();
    }
    public function hookNewOrder($params)
    {
        // 1.4 Versions
        return $this->hookActionValidateOrder($params);
    }

}
